// cpuDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cpu.h"
#include "cpuDlg.h"
#include "umfh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#pragma comment(lib, "umf.lib")

/////////////////////////////////////////////////////////////////////////////
// CCpuDlg dialog

CCpuDlg::CCpuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCpuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCpuDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCpuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCpuDlg)
	DDX_Control(pDX, IDC_LIST1, m_list1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCpuDlg, CDialog)
	//{{AFX_MSG_MAP(CCpuDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BTN_READ, OnBtnRead)
	ON_BN_CLICKED(IDC_BTN_AUTHEN, OnBtnAuthen)
	ON_BN_CLICKED(IDC_BTN_RESET, OnBtnReset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCpuDlg message handlers

BOOL CCpuDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CEdit* m_edit_pwd = (CEdit*)GetDlgItem(IDC_EDIT_PWD);
	CEdit* m_edit_Content = (CEdit*)GetDlgItem(IDC_EDIT_CONFIG_DATA);

	m_edit_pwd->SetWindowText("E54747");
	m_edit_Content->SetLimitText (216*2);
	m_edit_pwd->SetLimitText (3*2);

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCpuDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCpuDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCpuDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	//Init communicate port (link reader)   
	icdev=fw_init(100,0);
	if ((int)icdev == -1)
	{
		m_list1.AddString ("IC_InitComm Error");
		return;
	}
	m_list1.AddString ("IC_InitComm ok");
}

void CCpuDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	__int16 st;
	int sLen;
	CEdit* m_edit_Content = (CEdit*)GetDlgItem(IDC_EDIT_CONFIG_DATA);
	int flag=-1;
	unsigned char revLen = 0;
	UCHAR send_cmd[500]={0};
	UCHAR receive_data[500]={0}; 
	UCHAR sendbuffer[500]={0};
	unsigned char cmdBuf[] = {0x90, 0x00};

    CString m_Sendcommand;
	int times;
	int remaind;
	unsigned char ucSingleCmd[128]={0x00,0xB4,0x00,0x18,0x10};
	int curAddr = 0x18;
	int i;
	int onceDataLen = 8;

	m_edit_Content->GetWindowText(m_Sendcommand);

	sLen=m_Sendcommand.GetLength()/2;

	if(sLen != 216)
	{
		m_list1.AddString("Data Length Error!");
		return ;
	}

	if(a_hex(send_cmd, (unsigned char *)m_Sendcommand.GetBuffer(0), sLen))
	{
		m_list1.AddString("Data invalid format!");
		return ;
	}

	times = sLen / onceDataLen;
	remaind = sLen % onceDataLen;

	if(remaind != 0)
		times += 1;

	for(i=0; i < times; i++)
	{
		if(i != times-1)
			sLen = onceDataLen;
		else
			sLen = (remaind != 0)?remaind:onceDataLen;

		ucSingleCmd[3] = curAddr;
		ucSingleCmd[4] = sLen;

		memcpy(&ucSingleCmd[5], &send_cmd[i*onceDataLen], sLen);

		st = fw_cpuapdu((HANDLE)icdev,sLen + 5,ucSingleCmd,&revLen,receive_data);

		if(st<0)
		{
			m_list1.AddString("IC_CpuApdu Error!");
			return ;
		}
		else 
		{
			if(memcmp(cmdBuf, receive_data, 2))
			{
				m_list1.AddString("IC_CpuApdu Error!");
				return ;
			}
		}

		curAddr += onceDataLen;
	}

	m_Sendcommand.Empty();

	m_list1.AddString("Write card OK");
	

}
/////////// Clear message
void CCpuDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	m_list1.ResetContent ();
}



BOOL CCpuDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	if ((int)icdev != -1)
		fw_exit(icdev);
	return CDialog::DestroyWindow();
}

void CCpuDlg::OnBtnRead() 
{
	// TODO: Add your control notification handler code here
	__int16 st;
	int sLen;
	CEdit* m_edit_Content = (CEdit*)GetDlgItem(IDC_EDIT_READ);
	int flag=-1;
	unsigned char revLen = 0;
	UCHAR send_cmd[500]={0};
	UCHAR receive_data[500]={0}; 
	UCHAR sendbuffer[500]={0};
	unsigned char cmdBuf[] = {0x90, 0x00};
	
    CString m_Sendcommand = "00B60018D8";

	sLen=m_Sendcommand.GetLength()/2;

	if(a_hex(send_cmd,  (unsigned char *)m_Sendcommand.GetBuffer(0), sLen))
	{
		m_list1.AddString("Data invalid format!");
		return ;
	}

    st=fw_cpuapdu( (HANDLE)icdev,sLen,send_cmd,&revLen,receive_data);
	hex_a(sendbuffer,receive_data,revLen*2);
    if(st<0)
	{
		m_list1.AddString("IC_CpuApdu Error!");
		return ;
	}
	else 
	{
		if(memcmp(cmdBuf, &receive_data[revLen-2], 2))
		{
			m_list1.AddString("IC_CpuApdu Error!");
			return ;
		}

		sendbuffer[2*(revLen-2)] = 0x00;
		m_edit_Content->SetWindowText((CString)sendbuffer);
		m_Sendcommand.Empty();
    }
}

void CCpuDlg::OnBtnAuthen() 
{
	// TODO: Add your control notification handler code here
	int flag=-1;
	unsigned char  revLen = 0;
	UCHAR send_cmd[500]={0};
	UCHAR receive_data[500]={0}; 
	UCHAR sendbuffer[500]={0};
	unsigned char cmdBuf[] = {0x90, 0x00};
	CEdit* m_edit_pwd = (CEdit*)GetDlgItem(IDC_EDIT_PWD);
	int sLen;


	CString strAuthen;
	m_edit_pwd->GetWindowText(strAuthen);
	strAuthen = "00BA070003" + strAuthen;

	sLen=strAuthen.GetLength()/2;
	if(sLen != 8)
	{
		m_list1.AddString("password Length Error!");
		return ;
	}

	if(a_hex( send_cmd, (unsigned char *)strAuthen.GetBuffer(0), sLen))
	{
		m_list1.AddString("Data invalid format!");
		return ;
	}
    flag= fw_cpuapdu ((HANDLE)icdev,sLen,send_cmd,&revLen,receive_data);
    if(flag != 0)
	{
		m_list1.AddString("IC_CpuApdu Error!");
		return ;
	}
	else 
	{
		if(memcmp(cmdBuf, receive_data, 2))
		{
			m_list1.AddString("Authen Error!");
			return ;
		}
		m_list1.AddString("Authen OK!");
		strAuthen.Empty();
    }
}

void CCpuDlg::OnBtnReset() 
{
	// TODO: Add your control notification handler code here
	int st;
	int cardSt;

	st = fw_rdCardStatus(icdev, &cardSt);
	if (st<0)
	{
		m_list1.AddString ("IC_status error");
		m_list1.SetCurSel(m_list1.GetCount()-1);
		return;
	}
	if (cardSt == 0)
	{
		m_list1.AddString ("Found No card,Please Insert....");
		m_list1.SetCurSel(m_list1.GetCount()-1);
		return;
	}
	else if (cardSt == 1)
	{
		unsigned char data_buffer[256];
		__int16 st;
		int sLen;
		CEdit* m_edit_Content = (CEdit*)GetDlgItem(IDC_EDIT_CONFIG_DATA);
		
		memset(data_buffer,'\0',30);

		fw_setcpu((HANDLE)icdev, 0x0C);
		
		//Reset card
		st=fw_cpureset((HANDLE)icdev,(UCHAR*)&sLen,(UCHAR *)data_buffer);
		if(st<0)        
		{
			AfxMessageBox("Card reset failed!");
			return ;
		}
	}

	m_list1.AddString("Card reset ok.");
}
